/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.crops.flower;

import cloud.lemonslice.teastory.block.crops.flower.FlowerColorPair;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public enum FlowerColor implements StringRepresentable
{
    WHITE(0xFFFFFB, Items.f_42535_),
    RED(15679798, Items.f_42497_),
    YELLOW(16765952, Items.f_42539_),
    BLUE(2386082, Items.f_42494_),
    ORANGE(15952929, Items.f_42536_),
    PINK(15962537, Items.f_42489_),
    MAGENTA(15686556, Items.f_42537_),
    LIGHT_BLUE(3384284, Items.f_42538_),
    LIME(9297679, Items.f_42540_),
    GRAY(9079950, Items.f_42490_),
    LIGHT_GRAY(12830660, Items.f_42491_),
    CYAN(34706, Items.f_42492_),
    PURPLE(8737441, Items.f_42493_),
    BROWN(6241315, Items.f_42495_),
    GREEN(3329330, Items.f_42496_),
    BLACK(1252382, Items.f_42498_);

    private static final Map<FlowerColorPair, FlowerColor> COLOR_MAP;
    private final int color;
    private final Item dye;

    private FlowerColor(int colorValue, Item dye) {
        this.color = colorValue;
        this.dye = dye;
    }

    public String getString() {
        return this.toString().toLowerCase();
    }

    public int getColorValue() {
        return this.color;
    }

    public static FlowerColor getFlowerColor(String name) {
        return FlowerColor.valueOf(name.toUpperCase());
    }

    public Item getDye() {
        return this.dye;
    }

    public String getTranslation() {
        return I18n.m_118938_((String)("item.minecraft.firework_star." + this.getString()), (Object[])new Object[0]);
    }

    public static FlowerColor getHybColor(FlowerColor color1, FlowerColor color2) {
        if (color1 == color2) {
            return color1;
        }
        return COLOR_MAP.getOrDefault(new FlowerColorPair(color1, color2), BLACK);
    }

    private static void registerColorRecipe(FlowerColor in1, FlowerColor in2, FlowerColor out) {
        COLOR_MAP.put(new FlowerColorPair(in1, in2), out);
    }

    public String m_7912_() {
        return this.toString().toLowerCase();
    }

    static {
        COLOR_MAP = new HashMap<FlowerColorPair, FlowerColor>();
        FlowerColor.registerColorRecipe(RED, YELLOW, ORANGE);
        FlowerColor.registerColorRecipe(RED, BLUE, PURPLE);
        FlowerColor.registerColorRecipe(RED, WHITE, PINK);
        FlowerColor.registerColorRecipe(YELLOW, BLUE, GREEN);
        FlowerColor.registerColorRecipe(BLUE, WHITE, LIGHT_BLUE);
        FlowerColor.registerColorRecipe(RED, ORANGE, BROWN);
        FlowerColor.registerColorRecipe(PINK, PURPLE, MAGENTA);
        FlowerColor.registerColorRecipe(YELLOW, GREEN, LIME);
        FlowerColor.registerColorRecipe(WHITE, GREEN, LIME);
        FlowerColor.registerColorRecipe(BLACK, WHITE, GRAY);
        FlowerColor.registerColorRecipe(GRAY, WHITE, LIGHT_GRAY);
        FlowerColor.registerColorRecipe(BLUE, GREEN, CYAN);
    }
}

